# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 10
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR10_strategy.txt
# LLM Suggested Fallback: Not Provided

def celestial_serenity(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Early Rounds (1-3)
    if current_round == 1:
        return "C"
    if current_round <= 3:
        return opp_history[-1]
    
    # Middle Rounds (4-7)
    if current_round <= 7:
        # Check if opponent has been consistently cooperating
        if all(move == "C" for move in opp_history[:3]):
            # Analyze opponent's code for exploitation patterns
            if "current_round % 2 == 1" in opponent_program_code and "return 'D'" in opponent_program_code:
                if current_round % 2 == 1:
                    return "D"
            return "C"
        else:
            # Firm but forgiving
            if opp_history[-1] == "D":
                return "D"
            return "C"
    
    # Late Rounds (8-10)
    if current_round >= 8:
        # Check if opponent's code suggests unconditional cooperation
        if "return 'C'" in opponent_program_code and "random" not in opponent_program_code:
            if current_round >= total_rounds - 1:
                return "D"
        # If opponent is retaliatory, maintain cooperation
        if "grim" in opponent_program_code.lower() or "trigger" in opponent_program_code.lower():
            return "C"
        # Default: defect in the final round if opponent is unpredictable
        if current_round == total_rounds:
            return "D"
        return opp_history[-1]
    
    return "C"